% SCRT calculation

% Initial data

Uw=36; % wozb voltage, V
fw=400; % wozb frequency, Hz
p=1; % poles pairs
Kdu=6; % sensitivity, V/deg
Dk=32; % outer diameter, mm
Dw=12; % inner diameter, mm
lk=14; % height, mm
delta=1; % gap, mm
M=45; % mass, gr
dpr=0.08; % diameter prov, mm

% additional data

Zwh=4000; % input resistance, ohm
kV=50; % voltage transformation coeff
kn=2; 
kzpr=0.22;      
kzps=0.32;     
k_delta=1.03;   %!!!!!!
k_mu=1.003;      %!!!!!!
Dn=30;          % diameter virubki
mu0=4*pi*1e-9;
zc=20;         
zp=12;          
bsh=0.5;        %!!!!!!
mu_n=2e4;       %!!!!!!
lz=8;         %!!!!!!
Dj=23;          %!!!!!!
Ufn=36;
Ll=4;         %!!!!!!
hps=0.28;       %!!!!!!
kzp=0.49;       %!!!!!!
lambda_p=1.3;   %!!!!!!
lambda_l=0.2;   %!!!!!!
rho1=1.67*1e-6;

% hshc=0.5;
% hshp=0.5;

bshc=0.5;
bshp=0.5;

clc

% 1. Induction & current density

disp('--------------------------------------');

Bzh=0.45*sqrt(400*50/(fw*Dk));
j0=300*sqrt(400*50/(fw*Dk));

disp('1.');
disp(['   B=' num2str(Bzh) ' ']);
disp(['     i0=' num2str(j0) ' /2']);
disp(' ');

% 2. 

ks=kn*kzpr/kzps;        

disp('2.');
disp(['   ks=' num2str(ks) ' ']);
disp(' ');

% 3.

delta_st=delta*k_delta*k_mu;

disp('3.');
disp(['   delta=' num2str(delta_st) ' mm']);
disp(' ');

% 4.

a=8*Bzh*1e-4*delta_st*1e-1/(mu0*j0*kzps);
aDn=a/Dn^2;

disp('4.');
disp(['a=' num2str(a) ' cm2']);
disp([' a/Dn^2=' num2str(Bzh) ' ']);
disp(' ');

% 5.

%gamma=input('gamma=');
%khi=input('khi=D/Dn=');
gamma=2.8;
khi=0.585;

disp(' ');

% 6.

D=khi*Dn;
hj2=D/gamma;
tzc=pi*D/zc;
bzc=tzc/gamma;
tzp=pi*(D-2*delta)/zp;
bzp=tzp/gamma;

hshc=0.5; %hj2/2;
hshp=0.5; %hj2/2;
p=2;

% hac=(D-2*delta)/p/gamma;
hac=hj2/2;
hap=hac;

Dac=4;

d1c=(pi*((D-2*delta)+2*hshc)-bzc*zc)/(zc-pi);
d2c=(pi*(Dn-2*hac)-bzc*zc)/(zc+pi);
hnc=(Dn-(D-2*delta)-2*hac)/2;
h12c=hnc-0.5*(d1c+d2c+2*hshp);
Sps1=pi/8*(d1c^2+d2c^2)+0.5*h12c*(d1c+d2c);

d1p=(((D-2*delta)-2*hshp)*pi-bzp*zp)/(zp+pi);
d2p=((Dac+2*hap)*pi-bzp*zp)/(zp-pi);
h12p=0.5*((D-2*delta)-d1p-2*hshp-zp*(bzp+d2p)/pi);
hnp=0.5*(d1p+d2p)+h12p+hshp;
Spr1=pi/8*(d1p^2+d2p^2)+h12p*(d1p+d2p)/2;


dlt_h=(0.35*sqrt(400/fw));

disp('6.     : ');
disp(['D=' num2str(D) ' mm']);
disp(['2hj=' num2str(hj2) ' mm']);
disp(['tzc=' num2str(tzc) ' mm']);
disp(['bzc=' num2str(bzc) ' mm']);
disp(['tzp=' num2str(tzp) ' mm']);
disp(['bzp=' num2str(bzp) ' mm']);
disp(' ');
disp(['d1c=' num2str(d1c) ' mm']);
disp(['d2c=' num2str(d2c) ' mm']);
disp(['hnc=' num2str(hnc) ' mm']);
disp(['h12c=' num2str(h12c) ' mm']);
disp(['Sps1=' num2str(bzp) ' mm2']);
disp(['bshc=' num2str(bshc) ' mm']);
disp(' ');
disp(['d1p=' num2str(d1p) ' mm']);
disp(['d2p=' num2str(d2p) ' mm']);
disp(['h12p=' num2str(h12p) ' mm']);
disp(['hnp=' num2str(hnp) ' mm']);
disp(['Spr1=' num2str(Spr1) ' mm2']);
disp(['bshp=' num2str(bshp) ' mm']);
disp(' ');
disp(['delta_h=' num2str(dlt_h) ' mm']);
disp(' ');

% 7.

% Sps1_m=(pi/(4*zc)*(((Dn-hj2)^2-D)^2)-bzc/2*(Dn-hj2-D))*kzps/0.49;
% Spr1_m=(pi/(4*zp)*(D-hj2)^2-bzp/2*(D-hj2))*kzpr/0.49;

% Sps1=input(['Sps1 (' num2str(Sps1_m) ')']);
% Spr1=input(['Spr1 (' num2str(Spr1_m) ')']);

% 8.

% Sps1_st=pi/(4*zc)*(((Dn-hj2)^2-D)^2)-bzc/2*(Dn-hj2-D);
% kzps=0.49*Sps1/Sps1_st;

% Spr1_st=pi/(4*zp)*(D-hj2)^2-bzp/2*(D-hj2);
%kzpr=0.49*Spr1/Spr1_st;

% disp('8.');
% disp(['Sps1"=' num2str(Sps1_st) ' mm2']);
% disp(['kzps=' num2str(kzps) ' ']);
% disp(['Spr1"=' num2str(Spr1_st) ' mm2']);
% disp(['kzpr=' num2str(kzpr) ' ']);
% disp(' ');

% 9. 

gamma_c=((bsh/delta)^2)/(5+(bsh/delta));
gamma_p=gamma_c;
k_delta=tzc/(tzc-gamma_c*delta)*tzp/(tzp-gamma_p*delta);
kmu_n=1+gamma/(mu_n*delta*k_delta)*(lz+Dj/2);

disp('9.');
disp(['gamma_c=gamma_p=' num2str(gamma_c) ' ']);
disp(['k_delta=' num2str(k_delta) ' ']);
disp(['k_mu_n=' num2str(kmu_n) ' ']);
disp(' ');

% 10.


l=lk-4*Sps1/(Dk-D);

% l=round(kl*D);

disp('10.');
% disp(['kl=' num2str(kl) ' ']);
disp(['l=' num2str(l) ' mm']);

% II Windings parameters

% 1.

k0=zc/pi+Ll/(D*1e-1+hps);
rf=8*sqrt(2)*rho1*delta_st*1e-1*(1+Ll/l)*(1+(D+hnc)/(l+Ll))/(pi*mu0*fw*D*1e-1*Sps1*1e-2*zc*kzp);
xfs=4*pi*delta_st*1e-1*(lambda_p+lambda_l*(D+hnc)/l*k0)/(D*1e-1*zc)+4/(zc^2);   %!!!!!!!!!!!!!!!!!

kl=2*mu0*gamma^2*Ufn^2/(pi^2*(1+xfs)*fw*delta_st*1e-1*(D*1e-1)^2*(Bzh*1e-4)^2*Zwh);

% k0=
% rf=
% xfs=

disp('II.');
disp(' ');
disp('1.');
disp(['k0=' num2str(k0) ' ']);
disp(['rf=' num2str(rf) ' ']);
disp(['xfs=' num2str(xfs) ' ']);
disp(' ');

% 2.

weff=sqrt(delta_st*1e-1*Zwh/((1+xfs)*4*fw*mu0*D*1e-1*l*1e-1));
weff=weff;
disp('2.');
disp(['weff=' num2str(round(weff)) ' ']);
disp(' ');

% 3.

ii=1:5;
w1=round(4*weff/zc*sin((2*ii-1)*pi/zc));

disp('2.');
disp(['   :' num2str(w1)]);
weff_=2*sum(w1.*sin((2*ii-1)*pi/zc));

disp(['weff_=' num2str(round(weff_)) ' ']);    
disp(' ');

% 4.

q0=Sps1*kzp/(2*w1(3));
d0=sqrt(4*q0/pi);

disp('4.');
disp(['q0=' num2str(q0) ' mm2']);
disp(['d0=' num2str(d0) ' mm']);
disp(' ');

% 5.

% Xm=4*pi*fw*mu0*l*bzc*weff^2/delta_st;
% E1=Uw/abs(1+(rf+sqrt(-1)*xfs)/sqrt(-1)/Xm);

E1=Uw/(1+xfs);
p=2;

wefa=Kdu*weff*kV/(180/pi*p*E1);

% wefa=weff*kV*(1+xfs);



disp('5.');
% disp(['Xm=' num2str(Xm) ' ']);
disp(['E1=' num2str(E1) ' V']);
disp(['wefa=' num2str(wefa) ' ']);
disp(' ');

% 6.

ii=1:3;
w2=round(4*wefa/zp*sin((2*ii-1)*pi/zp));

disp('2.');
disp(['   :' num2str(w2)]);
wefa_=2*sum(w2.*sin((2*ii-1)*pi/zp));

disp(['wefa_=' num2str(wefa_) ' ']);    
disp(' ');

% 7.

q0r=Spr1*kzp/(2*w2(2));
d0r=sqrt(4*q0r/pi);

disp('7.');
disp(['q0=' num2str(q0r) ' mm2']);
disp(['d0=' num2str(d0r) ' mm']);

disp('--------------------------------------');
