unit MainForm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, TeeProcs, TeEngine, Chart, Buttons, Grids,
  Series;

type
  TForm1 = class(TForm)
    sgTb2: TStringGrid;
    sgTb1: TStringGrid;
    Label1: TLabel;
    Label2: TLabel;
    btFind: TButton;
    btClose: TBitBtn;
    rbTog1: TRadioButton;
    rbEve1: TRadioButton;
    cbSel1: TComboBox;
    edNmin: TEdit;
    edNmax: TEdit;
    edLen: TEdit;
    Label4: TLabel;
    Chart1: TChart;
    Series1: TLineSeries;
    Series2: TLineSeries;
    Series3: TLineSeries;
    Series4: TLineSeries;
    edStep: TEdit;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Chart2: TChart;
    rbTog2: TRadioButton;
    rbEve2: TRadioButton;
    cbSel2: TComboBox;
    Series5: TLineSeries;
    Series6: TLineSeries;
    Series7: TLineSeries;
    Panel1: TPanel;
    Panel2: TPanel;
    procedure rbEve1Click(Sender: TObject);
    procedure rbTog1Click(Sender: TObject);
    procedure btFindClick(Sender: TObject);
    procedure LinFind;
    procedure BinFind;
    procedure LinFindAcc;
    procedure SortA;
    procedure SortB;
    procedure Verify;
    procedure rbValClick(Sender: TObject);
    procedure rbIntClick(Sender: TObject);
    procedure Fill;

    procedure FormCreate(Sender: TObject);
    procedure cbSel1Change(Sender: TObject);
    procedure rbTog2Click(Sender: TObject);
    procedure rbEve2Click(Sender: TObject);
    procedure cbSel2Change(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  Tim : array [1..6,  1..3] of TDateTime;
  A : file of Word;
  B, arA : array of Word;
  Nmin, Nmax, Step, K, t, i, m, rnd, Fval : Word;
  SortA1, SortA2, SortAB, LinF1, LinF2, BinF, LinFAcc: array [0..1, 1..4, 1..65535] of Word;
  TSortA1, TSortA2, TSortAB, TLinF1, TLinF2, TBinF, TLinFAcc: array [1..65535] of Word;
  Acc : array [1..3, 1..65535] of Word;
implementation

{$R *.dfm}

procedure TForm1.Fill;
var
  r : Integer;
begin
  Rewrite(A);
  for r:=1 to i do                     // 
  begin                                // 
    Fval:=Random(64000);
    Write(A, Fval);
  end;
end;

procedure TForm1.LinFind;               // 
var
  s1, s2 : Word;
begin
  for s1:=0 to K-1 do
    for s2:=0 to i-1 do
      begin
        Seek(A, s2);
        Read(A, Fval);
        if (B[s1]=Fval) then Exit;
      end;
end;

procedure TForm1.BinFind;                // 
var
  s1, cou, cou1, cou2 : integer;
label
  1;
begin

  for s1:=0 to K-1 do
  begin
    cou1:=0;
    cou2:=i-1;
    While cou1<=cou2 do
    begin
      cou:=(cou2+cou1) div 2;
      Seek(A, cou);
      Read(A, Fval);
      if (Fval=B[s1]) then goto 1
        else if Fval<B[s1] then cou1:=cou+1
          else cou2:=cou-1;
    end;
1 :   end;
end;

procedure TForm1.LinFindAcc;             //   
var
  s1, s2, cou : Word;
begin
  cou:=1;
  for s1:=0 to K-1 do
    for s2:=0 to i-1 do
      begin
        Seek(A, s2);
        Read(A, Fval);
        if (B[s1]=Fval) then
        begin
          Acc[1, cou]:=s2;
          Acc[2, cou]:=s1;
          Acc[3, cou]:=Fval;
          cou:=cou+1;
        end;
      end;
end;

procedure TForm1.SortA;
var
  r, d : integer;
  tmp, val : Word;
begin
  SetLength(arA, i);
  for r:=0 to i-1 do
  begin
    Seek(A, r);
    Read(A, val);
    arA[r]:=val;
  end;

  for r:=0 to i-2 do
    for d:=r+1 to i-1 do
    begin
      if (arA[r]>arA[d]) then
      begin
        tmp:=arA[r];
        arA[r]:=arA[d];
        arA[d]:=tmp;
      end;
    end;

  Rewrite(A);
  for r:=0 to i-1 do Write(A, arA[r]);


end;

procedure TForm1.SortB;
var
  r, d : integer;
  tmp : Word;
begin
  for r:=0 to K-2 do
    for d:=r+1 to K-1 do
    begin
      if (B[r]>B[d]) then
      begin
        tmp:=B[r];
        B[r]:=B[d];
        B[d]:=tmp;
      end;
    end;
end;

procedure TForm1.Verify;                      //
begin
  if (edNmin.Text='') or (edNmax.Text='') or (edStep.Text='') or (edLen.Text='') then
  begin
    ShowMessage('   !');
    Abort;
  end;

  try
    Nmin:=StrToInt(edNmin.Text);
    Nmax:=StrToInt(edNmax.Text);
    Step:=StrToInt(edStep.Text);
    K:=StrToInt(edLen.Text);
  except
    ShowMessage('   !');
    Abort;
  end;

  if (StrToInt(edNmin.Text)<=0) or (StrToInt(edNmax.Text)<=0) or
    (StrToInt(edStep.Text)<=0) or (StrToInt(edLen.Text)<=0) or
    (StrToInt(edNmin.Text)>65535) or (StrToInt(edNmin.Text)>65535) or
    (StrToInt(edStep.Text)>65535) or (StrToInt(edLen.Text)>65535) then
  begin
    ShowMessage('     1..65535!');
    Abort;
  end;

  if (StrToInt(edNmin.Text)>=StrToInt(edNmax.Text)) then
  begin
    ShowMessage('      !');
    Abort;
  end;
end;

procedure TForm1.rbEve1Click(Sender: TObject);
begin
cbSel1.Enabled:=true;
Chart1.Series[1].Active:=false;
Chart1.Series[2].Active:=false;
Chart1.Series[3].Active:=false;
Chart1.Series[0].Active:=false;
Chart1.Series[cbSel1.ItemIndex].Active:=true;
end;

procedure TForm1.rbTog1Click(Sender: TObject);
begin
cbSel1.Enabled:=false;
Chart1.Series[1].Active:=true;
Chart1.Series[2].Active:=true;
Chart1.Series[3].Active:=true;
Chart1.Series[0].Active:=true;
end;

procedure TForm1.btFindClick(Sender: TObject);
begin
  Verify;
  //Chart1.SeriesList.Clear;
  AssignFile(A, 'file.bin');
  Rewrite(A);
  sgTb1.ColCount:=5;
  sgTb1.RowCount:=Nmax-Nmin;
  SetLength(B, K);                            //  B

  for t:=0 to K-1 do                         // 
  begin                                      // 
    rnd:=Random(64000);
    B[t]:=rnd;
  end;

  t:=1;
  i:=Nmin;
  While i<Nmax do                           //  
  begin
    Fill;                                    // 
    DecodeTime(Time, LinF1[0, 1, t], LinF1[0, 2, t], LinF1[0, 3, t], LinF1[0, 4, t]);
    LinFind;
    DecodeTime(Time, LinF1[1, 1, t], LinF1[1, 2, t], LinF1[1, 3, t], LinF1[1, 4, t]);
    TLinF1[t]:=Linf1[1, 4, t]+1000*LinF1[1, 3, t]-Linf1[0, 4, t]-1000*LinF1[0, 3, t];
    sgTb1.Cells[0, t]:=FloatToStr(i);
    sgTb1.Cells[1, t]:=FloatToStr(TLinF1[t]);
    Chart1.SeriesList[0].AddXY(i, TLinF1[t], '');
    i:=i+Step;
    t:=t+1;
  end;
  if i>=Nmax then                                // 
  begin                                         //  Nmax
    i:=Nmax;
    Fill;
    DecodeTime(Time, LinF1[0, 1, t], LinF1[0, 2, t], LinF1[0, 3, t], LinF1[0, 4, t]);
    LinFind;
    DecodeTime(Time, LinF1[1, 1, t], LinF1[1, 2, t], LinF1[1, 3, t], LinF1[1, 4, t]);
    TLinF1[t]:=Linf1[1, 4, t]+1000*LinF1[1, 3, t]-Linf1[0, 4, t]-1000*LinF1[0, 3, t];
    sgTb1.Cells[0, t]:=FloatToStr(i);
    sgTb1.Cells[1, t]:=FloatToStr(TLinF1[t]);
    Chart1.SeriesList[0].AddXY(i, TLinF1[t], '');
  end;

                                         

    t:=1;
    i:=Nmin;
    While i<Nmax do                           //  
  begin                                       
    Fill;
    DecodeTime(Time, SortA1[0, 1, t], SortA1[0, 2, t], SortA1[0, 3, t], SortA1[0, 4, t]);
    SortA;                                    //  A
    DecodeTime(Time, LinF2[0, 1, t], LinF2[0, 2, t], LinF2[0, 3, t], LinF2[0, 4, t]);
    LinFind;
    DecodeTime(Time, LinF2[1, 1, t], LinF2[1, 2, t], LinF2[1, 3, t], LinF2[1, 4, t]);
    TLinF2[t]:=Linf2[1, 4, t]+1000*LinF2[1, 3, t]-Linf2[0, 4, t]-1000*LinF2[0, 3, t];
    TSortA1[t]:=Linf2[1, 4, t]+1000*LinF2[1, 3, t]-SortA1[0, 4, t]-1000*SortA1[0, 3, t];
    sgTb1.Cells[2, t]:=FloatToStr(TLinF2[t]);
    sgTb2.Cells[0, t]:=FloatToStr(i);
    sgTb2.Cells[1, t]:=FloatToStr(TSortA1[t]);
    Chart1.SeriesList[1].AddXY(i, TLinF2[t], '');
    Chart2.SeriesList[0].AddXY(i, TSortA1[t], '');
    i:=i+Step;
    t:=t+1;
  end;
  if i>=Nmax then                                // 
  begin                                         //  Nmax
    i:=Nmax;
    Fill;
    DecodeTime(Time, SortA1[0, 1, t], SortA1[0, 2, t], SortA1[0, 3, t], SortA1[0, 4, t]);
    SortA;
    DecodeTime(Time, LinF2[0, 1, t], LinF2[0, 2, t], LinF2[0, 3, t], LinF2[0, 4, t]);
    LinFind;
    DecodeTime(Time, LinF2[1, 1, t], LinF2[1, 2, t], LinF2[1, 3, t], LinF2[1, 4, t]);
    TLinF2[t]:=Linf2[1, 4, t]+1000*LinF2[1, 3, t]-Linf2[0, 4, t]-1000*LinF2[0, 3, t];
    TSortA1[t]:=Linf2[1, 4, t]+1000*LinF2[1, 3, t]-SortA1[0, 4, t]-1000*SortA1[0, 3, t];
    sgTb2.Cells[0, t]:=FloatToStr(i);
    sgTb1.Cells[2, t]:=FloatToStr(TLinF2[t]);
    sgTb2.Cells[1, t]:=FloatToStr(TSortA1[t]);
    Chart1.SeriesList[1].AddXY(i, TLinF2[t], '');
    Chart2.SeriesList[0].AddXY(i, TSortA1[t], '');
  end;


    t:=1;
    i:=Nmin;
    While i<Nmax do                           // 
  begin
    Fill;
    DecodeTime(Time, SortA2[0, 1, t], SortA2[0, 2, t], SortA2[0, 3, t], SortA2[0, 4, t]);
    SortA;
    DecodeTime(Time, BinF[0, 1, t], BinF[0, 2, t], BinF[0, 3, t], BinF[0, 4, t]);
    BinFind;
    DecodeTime(Time, BinF[1, 1, t], BinF[1, 2, t], BinF[1, 3, t], BinF[1, 4, t]);
    TBinF[t]:=BinF[1, 4, t]+1000*BinF[1, 3, t]-BinF[0, 4, t]-1000*BinF[0, 3, t];
    TSortA2[t]:=BinF[1, 4, t]+1000*BinF[1, 3, t]-SortA2[0, 4, t]-1000*SortA2[0, 3, t];
    sgTb1.Cells[3, t]:=FloatToStr(TBinF[t]);
    sgTb2.Cells[2, t]:=FloatToStr(TSortA2[t]);
    Chart1.SeriesList[2].AddXY(i, TBinF[t], '');
    Chart2.SeriesList[1].AddXY(i, TSortA2[t], '');
    i:=i+Step;
    t:=t+1;
  end;
  if i>=Nmax then                                // 
  begin                                         //  Nmax
    i:=Nmax;
    Fill;
    DecodeTime(Time, SortA2[0, 1, t], SortA2[0, 2, t], SortA2[0, 3, t], SortA2[0, 4, t]);
    SortA;
    DecodeTime(Time, BinF[0, 1, t], BinF[0, 2, t], BinF[0, 3, t], BinF[0, 4, t]);
    LinFind;
    DecodeTime(Time, BinF[1, 1, t], BinF[1, 2, t], BinF[1, 3, t], BinF[1, 4, t]);
    TBinF[t]:=BinF[1, 4, t]+1000*BinF[1, 3, t]-BinF[0, 4, t]-1000*BinF[0, 3, t];
    TSortA2[t]:=BinF[1, 4, t]+1000*BinF[1, 3, t]-SortA2[0, 4, t]-1000*SortA2[0, 3, t];
    sgTb1.Cells[3, t]:=FloatToStr(TBinF[t]);
    sgTb2.Cells[2, t]:=FloatToStr(TSortA2[t]);
    Chart1.SeriesList[2].AddXY(i, TBinF[t], '');
    Chart2.SeriesList[1].AddXY(i, TSortA2[t], '');
  end;


    t:=1;
    i:=Nmin;
    While i<Nmax do                           // 
  begin                                        // 
    Fill;
    DecodeTime(Time, SortAB[0, 1, t], SortAB[0, 2, t], SortAB[0, 3, t], SortAB[0, 4, t]);
    SortA;
    SortB;                                    //  B
    DecodeTime(Time, LinFAcc[0, 1, t], LinFAcc[0, 2, t], LinFAcc[0, 3, t], LinFAcc[0, 4, t]);
    LinFindAcc;
    DecodeTime(Time, LinFAcc[1, 1, t], LinFAcc[1, 2, t], LinFAcc[1, 3, t], LinFAcc[1, 4, t]);
    TLinFAcc[t]:=LinFAcc[1, 4, t]+1000*LinFAcc[1, 3, t]-LinFAcc[0, 4, t]-1000*LinFAcc[0, 3, t];
    TSortAB[t]:=LinFAcc[1, 4, t]+1000*LinFAcc[1, 3, t]-SortAB[0, 4, t]-1000*SortAB[0, 3, t];
    sgTb1.Cells[4, t]:=FloatToStr(TLinFAcc[t]);
    sgTb2.Cells[3, t]:=FloatToStr(TSortAB[t]);
    Chart1.SeriesList[3].AddXY(i, TLinFAcc[t], '');
    Chart2.SeriesList[2].AddXY(i, TSortAB[t], '');
    i:=i+Step;
    t:=t+1;
  end;
  if i>=Nmax then                                // 
  begin                                         //  Nmax
    i:=Nmax;
    Fill;
    DecodeTime(Time, SortAB[0, 1, t], SortAB[0, 2, t], SortAB[0, 3, t], SortAB[0, 4, t]);
    SortA;
    SortB;
    DecodeTime(Time, LinFAcc[0, 1, t], LinFAcc[0, 2, t], LinFAcc[0, 3, t], LinFAcc[0, 4, t]);
    LinFindAcc;
    DecodeTime(Time, LinFAcc[1, 1, t], LinFAcc[1, 2, t], LinFAcc[1, 3, t], LinFAcc[1, 4, t]);
    TLinFAcc[t]:=LinFAcc[1, 4, t]+1000*LinFAcc[1, 3, t]-LinFAcc[0, 4, t]-1000*LinFAcc[0, 3, t];
    TSortAB[t]:=LinFAcc[1, 4, t]+1000*LinFAcc[1, 3, t]-SortAB[0, 4, t]-1000*SortAB[0, 3, t];
    sgTb1.Cells[4, t]:=FloatToStr(TLinFAcc[t]);
    sgTb2.Cells[3, t]:=FloatToStr(TSortAB[t]);
    Chart1.SeriesList[3].AddXY(i, TLinFAcc[t], '');
    Chart2.SeriesList[2].AddXY(i, TSortAB[t], '');
  end;

  sgTb1.RowCount:=t+1;

  CloseFile(A);
  Erase(A);
  Finalize(B);
end;

procedure TForm1.rbValClick(Sender: TObject);
begin
edNmax.Visible:=false;
edStep.Visible:=false;
end;

procedure TForm1.rbIntClick(Sender: TObject);
begin
edNmax.Visible:=true;
edStep.Visible:=true;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Randomize;
  sgTb1.Cells[0, 0]:='N';
  sgTb1.Cells[1, 0]:='t1';
  sgTb1.Cells[2, 0]:='t2';
  sgTb1.Cells[3, 0]:='t';
  sgTb1.Cells[4, 0]:='t-';

  sgTb2.Cells[0, 0]:='N';
  sgTb2.Cells[1, 0]:='t2+tA';
  sgTb2.Cells[2, 0]:='t+tA';
  sgTb2.Cells[3, 0]:='t-+t';

  cbSel1.ItemIndex:=0;
  cbSel2.ItemIndex:=0;

  rbTog1.Checked:=true;
  rbTog2.Checked:=true;
end;

procedure TForm1.cbSel2Change(Sender: TObject);
begin
Chart2.Series[0].Active:=false;
Chart2.Series[1].Active:=false;
Chart2.Series[2].Active:=false;
Chart2.Series[cbSel2.ItemIndex].Active:=true;
end;

procedure TForm1.cbSel1Change(Sender: TObject);
begin
Chart1.Series[1].Active:=false;
Chart1.Series[2].Active:=false;
Chart1.Series[3].Active:=false;
Chart1.Series[0].Active:=false;
Chart1.Series[cbSel1.ItemIndex].Active:=true;
end;

procedure TForm1.rbEve2Click(Sender: TObject);
begin
cbSel2.Enabled:=true;
Chart2.Series[0].Active:=false;
Chart2.Series[1].Active:=false;
Chart2.Series[2].Active:=false;
Chart2.Series[cbSel2.ItemIndex].Active:=true;
end;

procedure TForm1.rbTog2Click(Sender: TObject);
begin
cbSel2.Enabled:=false;
Chart2.Series[0].Active:=true;
Chart2.Series[1].Active:=true;
Chart2.Series[2].Active:=true;
end;

end.
