%start list

%token UNKNOW
%token EXIT 
%token FONT SIZE
%token SCENTER SUNDERLINE UNDERLINE BOLD 
%token ADJUST NOADJUST LINELENGHT IN TIN
%token BREAKLINE SPACE LINESPACE
%token FILL NOFILL
%token DARG CARG SARG
%token TEXTSTR EMPTYSTR

%{
  #include "lex.yy.c"

  #define printT(STR) fprintf(yyout,(STR))
  #define printD(STR,D) fprintf(yyout,(STR),(D))
  #define Dyacc(T) {fprintf(stderr,"(DEBUG MESSAGE from yacc: rule '");fprintf(stderr,(T));fprintf(stderr,"'.\n yytext='%s' ta=%d tf=%d tb=%d tu=%d tc=%d cb=%d cu=%d cc=%d)\n",yytext,ta,tf,tb,tu,tc,cb,cu,cc);};

  int cb=-1,cu=-1,cc=-1,cl=-1;
  int co=-1;
  int ta=0,tf=0,tb=0,tu=0,tc=0,tp=0;
  int tFILL=0,cIN,cTIN,LS=0;
  char nhtext[YYLMAX];
  int i;

  void breakline(void)
   {printT("\n");
    for (i=0;i<(LS+1);i++) printT("<br>");
   }
%}

%% 
list:    | list string 
string:    text
         | command
         ;
command:   BREAKLINE 
            {breakline();}
         | SPACE comarg
            {printD("<spacer type=\"vertical\" size=%d>",$2*30);}
         | LINESPACE comarg
            {LS=$2;}
         | BOLD comarg
            {if (!tb) {tb=1;
                       printT("<b>");}
             cb=$2;}
         | UNDERLINE comarg
            {if (!tu) {tu=1;
                       printT("<u>");}
             cu=$2;}
         | SUNDERLINE
            {if (!tu) {tu=1;
                       printT("<u>");}
             cu=1;}
         | SCENTER 
            {if (!tc) {tc=1;
                       printT("<center>");}
             cc=1;}
         | FONT comarg
            {if (tf) printT("</font>");
             printD("<font face=\"%s\">",nhtext);
             tf=1;}
         | SIZE comarg
            {if (tf) printT("</font>");
             printD("<font size=%d>",$2);
             tf=1;}
         | ADJUST comarg
            {if (tp) {tp=0;printT("</pre>");};
             if (ta) printT("</div>");
             ta=1;
             printT("<div align=\"");
             switch (nhtext[0])
              {
               case 'l': printT("left");break;
               case 'r': printT("right");break;
               case 'c': printT("center");break;
               default : printT("left");break;
              }
             printT("\">");};
         | NOADJUST
            {if (tp) printT("</pre>");
             if (ta) printT("</div>");
             tp=1;
             ta=0;
             printT("<pre>");};
         | LINELENGHT comarg
         | IN comarg
            {cIN=$2;};
         | TIN comarg
            {cTIN=$2;};
         | FILL
            {tFILL=1;};
         | NOFILL
            {tFILL=0;};
         | UNKNOW comarg
            {fprintf(stderr,"unknow nroff command before arg '%s'\n",yytext);}
         | UNKNOW 
            {fprintf(stderr,"unknow nroff command: .%s\n",yytext);}
         | EXIT
            {return(0);}
         ;
comarg:    DARG
            {$$=atoi(yytext);}
         | CARG
            {nhtext[0]=yytext[0];}
         | SARG
            {for(i=0;yytext[i]!=0;i++) nhtext[i]=yytext[i];
             nhtext[i++]=0;}
         ;
text:      TEXTSTR 
            {if (cTIN) {for(i=0;i<cTIN;i++)
                         printT("&nbsp;");
                        cTIN=0;}
             else for(i=0;i<cIN;i++) 
                   printT("&nbsp;");
             printD("%s",yytext);
             if (!tFILL) breakline();
             if (!(cb<0)) cb--;
             if (!(cu<0)) cu--;
             if (!(cc<0)) cc--;
             if (!cb) {tb=0;printT("</b>");};
             if (!cu) {tu=0;printT("</u>");};
             if (!cc) {tc=0;printT("</center>");};}
         | EMPTYSTR
            {breakline();}
         ;
%% 
